/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.common.items;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlockEntity;

public class DollyItem
extends Item {
    public static final TagKey<Block> NONPICKABLE_CHEST_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("ironchests", "non_pickable_chests"));

    public DollyItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        GenericChestBlockEntity chest;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockState state = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        ItemStack stack = context.m_43722_();
        if (DollyItem.hasChest(stack) && !player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (DollyItem.hasChest(stack) && player.m_6144_()) {
            BlockPlaceContext blockPlaceContext = new BlockPlaceContext(context);
            if (!blockPlaceContext.m_7059_()) {
                return InteractionResult.PASS;
            }
            BlockState tagState = DollyItem.updateBlockState(blockPlaceContext, NbtUtils.m_129241_((CompoundTag)stack.m_41783_().m_128469_("BlockStateTag")));
            level.m_7731_(blockPlaceContext.m_8083_(), tagState, 11);
            DollyItem.loadBlockEntityTag(level.m_7702_(blockPlaceContext.m_8083_()), stack.m_41783_().m_128469_("BlockEntityTag"));
            stack.m_41783_().m_128473_("BlockStateTag");
            stack.m_41783_().m_128473_("BlockEntityTag");
            stack.m_41622_(1, (LivingEntity)player, player2 -> player2.m_21190_(player.m_7655_()));
            return InteractionResult.SUCCESS;
        }
        if (!state.m_204336_(NONPICKABLE_CHEST_TAG) && !DollyItem.hasChest(stack) && (blockEntity instanceof GenericChestBlockEntity && (chest = (GenericChestBlockEntity)blockEntity).viewers() == 0 || blockEntity instanceof ChestBlockEntity && ChestBlockEntity.m_59086_((BlockGetter)level, (BlockPos)pos) == 0)) {
            stack.m_41784_().m_128365_("BlockStateTag", (Tag)NbtUtils.m_129202_((BlockState)state));
            stack.m_41784_().m_128365_("BlockEntityTag", (Tag)blockEntity.m_187481_());
            level.m_46747_(pos);
            if (blockEntity instanceof GenericChestBlockEntity) {
                GenericChestBlockEntity chest2 = (GenericChestBlockEntity)blockEntity;
                chest2.setCanDropLock(false);
            }
            level.m_7471_(pos, false);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static void loadBlockEntityTag(BlockEntity blockEntity, CompoundTag tag) {
        if (blockEntity != null) {
            CompoundTag compoundTag2 = blockEntity.m_187480_();
            CompoundTag compoundTag3 = compoundTag2.m_6426_();
            compoundTag2.m_128391_(tag);
            compoundTag2.m_128405_("x", blockEntity.m_58899_().m_123341_());
            compoundTag2.m_128405_("y", blockEntity.m_58899_().m_123342_());
            compoundTag2.m_128405_("z", blockEntity.m_58899_().m_123343_());
            if (!compoundTag2.equals((Object)compoundTag3)) {
                blockEntity.m_142466_(compoundTag2);
                blockEntity.m_6596_();
            }
        }
    }

    private static BlockState updateBlockState(BlockPlaceContext context, BlockState newState) {
        if (newState.m_61138_((Property)BlockStateProperties.f_61362_)) {
            newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(context.m_43725_().m_8055_(context.m_8083_()).m_60713_(Blocks.f_49990_)));
        }
        if (newState.m_61138_((Property)ChestBlock.f_51479_)) {
            newState = (BlockState)newState.m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.SINGLE);
        }
        if (newState.m_61138_((Property)BlockStateProperties.f_61374_)) {
            newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_());
        }
        if (newState.m_61138_((Property)BlockStateProperties.f_61372_)) {
            newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)context.m_8125_().m_122424_());
        }
        return newState;
    }

    public boolean m_142095_() {
        return false;
    }

    public void m_6883_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Entity entity, int i, boolean bl) {
        Player player;
        if (DollyItem.hasChest(itemStack) && entity instanceof Player && !(player = (Player)entity).m_7500_() && !player.m_5833_()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 2));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 20, 3));
        }
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        if (DollyItem.hasChest(stack)) {
            String id = stack.m_41784_().m_128469_("BlockStateTag").m_128461_("Name");
            list.add((Component)Component.m_237110_((String)"item.dolly.chestid", (Object[])new Object[]{id}));
        }
        super.m_7373_(stack, level, list, tooltipFlag);
    }

    public static boolean hasChest(ItemStack stack) {
        return stack.m_41782_() && stack.m_41784_().m_128441_("BlockStateTag") && stack.m_41784_().m_128441_("BlockEntityTag");
    }

    public static float getChestId(ItemStack stack) {
        return DollyItem.hasChest(stack) ? 1.0f : -1.0f;
    }
}

